# coding=utf-8
import sys
import arcpy
import traceback


# 消息写出
def outputMsg(msg):
    arcpy.AddMessage(msg)


def excute():
    paramCount = len(sys.argv)
    if paramCount != 11:
        print ("获取参数失败")
        return
    try:
        # 输入要素工作空间
        workspace = sys.argv[1]
        workspace = workspace.replace("empty", " ")
        if " " in workspace:
            workspace = workspace.replace("'", "")
        # 输入要素图层名称
        inLayerName = sys.argv[2]
        # 输入要素过滤条件
        inLayerWhereClause = sys.argv[3]
        if inLayerWhereClause == "empty":
            inLayerWhereClause = ""
        inLayerWhereClause = inLayerWhereClause.replace("empty", " ")
        print (inLayerWhereClause)
        # 选择要素路径
        byLayerPath = sys.argv[4]
        byLayerPath = byLayerPath.replace("empty", " ")
        if " " in byLayerPath:
            byLayerPath = byLayerPath.replace("'", "")
        # 选择要素过滤条件
        byLayerWhereClause = sys.argv[5]
        if byLayerWhereClause == "empty":
            byLayerWhereClause = ""
        byLayerWhereClause = byLayerWhereClause.replace("empty", " ")
        print (byLayerWhereClause)
        # 空间关系
        overlap_type = sys.argv[10]
        # 缓冲值
        bufferValue = float(sys.argv[6])
        if bufferValue < 0:
            if overlap_type != "WITHIN_A_DISTANCE":
                bufferValue = 0
            else:
                bufferValue = str(bufferValue) + " Meters"
        # 输出结果路径
        outputPath = sys.argv[7]
        # 选择方式
        select_type = sys.argv[8]
        # 输出结果图层名称
        resultFeatureclass = sys.argv[9]

        arcpy.env.workspace = workspace
        print workspace
        # 创建图层对象
        inLayer = arcpy.MakeFeatureLayer_management(inLayerName, inLayerName + "_Layer", inLayerWhereClause)
        inLayer = arcpy.SelectLayerByAttribute_management(inLayer,"NEW_SELECTION",inLayerWhereClause)
        byLayer = arcpy.MakeFeatureLayer_management(byLayerPath, "byLayer", byLayerWhereClause)
        # 被整体包含需要单独处理，将相关对象union
        if overlap_type == "WITHIN_CLEMENTINI":
            arcpy.Dissolve_management(byLayer, outputPath + "//UnionFea")
            byLayer = arcpy.MakeFeatureLayer_management(outputPath + "//UnionFea", "unionLayer")
        # 按条件选择
        resultLayer = arcpy.SelectLayerByLocation_management(inLayer, overlap_type, byLayer,
                                                             bufferValue, selection_type=select_type)
        # 创建fieldMap将查询数据的objectid输出
        fieldMaps = arcpy.FieldMappings()
        fieldMap = arcpy.FieldMap()
        fields = arcpy.ListFields(resultLayer, field_type="OID")
        for field in fields:
            objectId = field.name
            fieldMap.addInputField(resultLayer, objectId)
            break
        checkIdField = fieldMap.outputField
        checkIdField.name = "checkFeaId"
        checkIdField.type = "Integer"
        fieldMap.outputField = checkIdField
        fieldMaps.addFieldMap(fieldMap)

        fields = arcpy.ListFields(resultLayer)
        for field in fields:
            if field.type == "OID":
                continue
            if field.type == "Geometry":
                continue
            fieldMap1 = arcpy.FieldMap()
            name = field.name
            fieldMap1.addInputField(resultLayer, name)
            targetField = fieldMap1.outputField
            targetField.name = name
            targetField.type = field.type
            fieldMap1.outputField = targetField
            fieldMaps.addFieldMap(fieldMap1)
        # 输出
        arcpy.FeatureClassToFeatureClass_conversion(resultLayer, outputPath, resultFeatureclass,
                                                    field_mapping=fieldMaps)
        print (outputPath)
    except Exception as e:
        outputMsg(e.message)
        traceback.print_exc()


if __name__ == '__main__':
    excute()
